﻿Imports System.Text
Public Class RS_232C_USB

    '(0)Class variable
    Private SerialPort As System.IO.Ports.SerialPort                                    'Serial Port Device
    Public MsgBuf As String = ""                                                        'Received Data

    '(1)Connect
    Public Function OpenInterface(ByVal port As String, ByVal speed As String) As Boolean
        Dim ret As Boolean = False

        Try
            SerialPort = New System.IO.Ports.SerialPort                                 'Create a serial port object
            SerialPort.PortName = port                                                  'Set the COM port
            SerialPort.BaudRate = Convert.ToInt32(speed)                                'Set communication speed
            SerialPort.Open()                                                           'Open the serial port
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        OpenInterface = ret
    End Function

    '(2)Disconnect
    Public Function CloseInterface() As Boolean
        Dim ret As Boolean = False

        Try
            If SerialPort.IsOpen Then
                SerialPort.Close()                                                      'Close the serial port
            End If
            SerialPort.Dispose()                                                        'Dispose the serial port object
            ret = True
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        CloseInterface = ret
    End Function

    '(3)Send commands
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False

        Try
            strMsg += vbCrLf                                                            'Add a terminator, CR+LR, to transmitted command
            SerialPort.Write(strMsg)                                                    'Write data in the transmit buffer
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        SendMsg = ret
    End Function

    '(4)Receive
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False
        Dim rcv As String = ""
        Dim buf As New StringBuilder()
        Dim sw As New Stopwatch()

        Try
            MsgBuf = ""                                                                 'Clear received data

            sw.Start()                                                                  'Start a stopwatch
            'Continue the loop until LF is received
            Do
                If SerialPort.BytesToRead > 0 Then
                    rcv = SerialPort.ReadExisting()                                     'Read data from the receive buffer
                    rcv = rcv.Replace(vbCr, "")                                         'Delete CR in received data
                    If rcv.IndexOf(vbLf) >= 0 Then                                      'End the loop when LF is received
                        rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                       'Extract data without LF and the following from the original received data
                        buf.Append(rcv)                                                 'Save the data
                        MsgBuf = buf.ToString()
                        Exit Do
                    Else
                        buf.Append(rcv)                                                 'Save the data
                    End If
                End If
                'Timeout processing
                If sw.ElapsedMilliseconds > timeout_ms Then                             'Get elapsed time
                    MsgBuf = "Timeout"
                    MsgBox(MsgBuf)
                    ReceiveMsg = ret
                    Exit Function
                End If
            Loop
            sw.Stop()                                                                   'Stop a stopwatch
            ret = True

        Catch Ex As Exception
            MsgBuf = "Error"
            MsgBox(Ex.Message)
        End Try

        ReceiveMsg = ret
    End Function

    '(5)Transmit and receive commands
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False

        If SerialPort.BytesToRead > 0 Then
            SerialPort.ReadExisting()                                                   'If exist the data in the receive buffer, read all data.
        End If

        ret = SendMsg(strMsg)                                                           'Transmit commands
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            'Receive response when command transmission is succeeded
            End If
        End If

        SendQueryMsg = ret
    End Function


End Class
